<?php
/**
 * Setup Groups Pages Component
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Components;

use SearchWP_Stats;

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! class_exists( '\\Dekode\\Nisje\\Components\\Advanced_Search' ) ) {

	/**
	 * Advanced Search Component Class
	 */
	class Advanced_Search extends Component {
		/**
		 * Constructor
		 */
		public function __construct() {
			$path = trailingslashit( __DIR__ );

			parent::start(
				'advanced-search',
				esc_html__( 'Advanced Search', 'nisje-advanced-search' ),
				$path
			);
		}

		/**
		 * Add frontend options
		 *
		 * @param array $options Options.
		 */
		public function add_frontend_option( $options ) {
			$options['features']['advancedSearch'] = true;
			return $options;
		}

		/**
		 * Setup Filters
		 */
		public function setup_filters() {
			add_filter( 'searchwp_dashboard_widget', '__return_false' );
			add_filter( 'cwp_swp_api_args', [ $this, 'filter_endpoint_args' ] );
			add_filter( 'searchwp_query_results', [ $this, 'filter_search_results' ], 10, 1 );
			add_action( 'wp_dashboard_setup', [ $this, 'add_dashboard_widget' ] );
			add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_styles' ] );
			add_filter( 'nisje_frontend_options', [ $this, 'add_frontend_option' ] );
		}

		/**
		 * Register REST endpoints
		 */
		public function register_rest_routes() {
			$this->include_file( 'rest-handlers/extend-post.php' );
			$this->include_file( 'rest-handlers/route.php' );

			$api = new \calderawp\swp_api\route( 'post' );
			$api->the_route();
		}

		/**
		 * Add dashboard widget
		 */
		public function add_dashboard_widget() {
			wp_add_dashboard_widget(
				'searchwp_widget', __( 'Advanced Search Statistics', 'nisje-advanced-search' ), [
					$this,
					'searchwp_widget',
				]
			);
		}

		/**
		 * Filter endpoint args
		 *
		 * @param array $args Arguments.
		 * @return array
		 */
		public function filter_endpoint_args( $args ) {
			return array_merge( [
				'post_type' => [
					'default' => [],
				],
			], $args );
		}

		/**
		 * Filter search results
		 *
		 * @param array $post_ids Post IDS.
		 * @return array
		 */
		public function filter_search_results( $post_ids ) {
			$current_user = get_current_user_id();
			$ret_post_ids = [];

			// Filter out post IDs that aren't applicable to the current user.
			foreach ( $post_ids as $post_id ) {
				$post = get_post( $post_id );

				// Check if post is connected to a group.
				if ( $post->post_parent ) {

					$group_id = $post->post_parent;

					// Check is a user should be able to see this post.
					if ( groups_is_user_member( $current_user, $group_id ) && ! groups_is_user_banned( $current_user, $group_id ) ) {
						// Add this ID from returned array.
						$ret_post_ids[] = $post_id;
					}
				} else {
					$ret_post_ids[] = $post_id;
				}
			}

			return $ret_post_ids;
		}

		/**
		 * Enqueue styles
		 */
		public function enqueue_styles() {
			wp_enqueue_style( 'nisje-advanced-search-admin', plugins_url( 'styles/styles.css', __FILE__ ), [], NISJE_ADVANCED_SEARCH_VERSION );
		}

		/**
		 * SearchWP widget
		 */
		public function searchwp_widget() {
			$stats = new SearchWP_Stats();

			$engine   = 'default';
			$limit    = 20;
			$min_hits = false;
			$max_hits = false;
			$exclude  = $stats->get_ignored_queries();
			$counts   = $stats->get_popular_searches(
				[
					'engine'   => $engine,
					'limit'    => $limit,
					'exclude'  => $exclude,
					'min_hits' => $min_hits,
					'max_hits' => $max_hits,
				]
			);

			/*
			 * Using advanced search triggers 4 searches
			 * from the front end at present (hence / 4).
			 */
			foreach ( $counts as $count ) {
				$count->searchcount = $count->searchcount / 4;
			}

			$stats->display( $counts, $engine );
		}
	}
}
