<?php
/**
 * ACF field group Alerts
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! function_exists( 'acf_add_local_field_group' ) ) {
	return;
}

$current_post_type = nisje_get_setting( 'post_type_name', 'alerts' );

$field_key_prefix = nisje_get_setting( 'field_key_prefix', 'alerts' );

acf_add_local_field_group( [
	'key'                   => $field_key_prefix . '_group',
	'title'                 => esc_html__( 'Settings', 'nisje-alerts' ),
	'fields'                => [
		[
			'key'           => $field_key_prefix . '_color',
			'label'         => esc_html__( 'Background Color', 'nisje-alerts' ),
			'name'          => $field_key_prefix . '_color',
			'type'          => 'select',
			'choices'       => [
				'black'  => esc_html__( 'Black', 'nisje-alerts' ),
				'yellow' => esc_html__( 'Yellow', 'nisje-alerts' ),
				'red'    => esc_html__( 'Red', 'nisje-alerts' ),
			],
			'default_value' => [
				0 => 'yellow',
			],
			'allow_null'    => 0,
			'multiple'      => 0,
			'ui'            => 0,
			'return_format' => 'value',
			'ajax'          => 0,
			'placeholder'   => '',
		],
	],
	'location'              => [
		[
			[
				'param'    => 'post_type',
				'operator' => '==',
				'value'    => $current_post_type,
			],
		],
	],
	'menu_order'            => 0,
	'position'              => 'normal',
	'style'                 => 'default',
	'label_placement'       => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen'        => '',
	'active'                => 1,
	'description'           => '',
] );
