<?php
/**
 * Plugin Name: Nisje - Front Page Alerts
 * Description: Allows administrators to add a custom alert box on the top of the page.
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     7.1.3
 * Text Domain: nisje-alerts
 * Domain Path: /languages/
 * License:     GPLv3 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Alerts;

defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_ALERTS_VERSION', '7.1.3' );

/**
 * Filters
 */
add_action( 'plugins_loaded', __NAMESPACE__ . '\\load_textdomain' );
add_action( 'nisje_include', __NAMESPACE__ . '\\includes' );
add_action( 'nisje_register_components', __NAMESPACE__ . '\register_components' );

/**
 * Load plugin textdomain.
 */
function load_textdomain() {
	load_plugin_textdomain( 'nisje-alerts', false, basename( __DIR__ ) . '/languages' );
}

/**
 * Include plugin components
 */
function includes() {
	require __DIR__ . '/updates.php';

	$current_plugin_version = NISJE_ALERTS_VERSION;
	$version_option_key     = 'nisje_alerts_version';
	$installed_version      = get_option( $version_option_key );

	// Do nothing if $installed_version is >= $plugin_version.
	if ( ! $installed_version || version_compare( $installed_version, $current_plugin_version, '<=' ) ) {
		add_action( 'init', 'nisje_alerts_activation' );
	}
}

/**
 * Include plugin components
 */
function register_components() {
	require __DIR__ . '/alerts/class-alerts.php';
	nisje_register_component( new \Dekode\Nisje\Components\Alerts() );
}

/**
 * Registers scripts and styles
 */
function nisje_alerts_register_scripts_and_styles() {
	wp_enqueue_script( 'nisje-plugin-alerts' );
	wp_enqueue_style( 'nisje-plugin-alerts' );
}
add_action( 'wp_enqueue_scripts', __NAMESPACE__ . '\\nisje_alerts_register_scripts_and_styles', 20 );
