<?php
/**
 * Set up alert post type
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$cap = nisje_get_setting( 'capability_key', 'alerts' );

$args = apply_filters( 'nisje_post_type_alert_args', [
	'labels'              => [
		'name'          => esc_html__( 'Alerts', 'nisje-alerts' ),
		'singular_name' => esc_html__( 'Alert', 'nisje-alerts' ),
	],
	'public'              => false,
	'publicly_queryable'  => false,
	'exclude_from_search' => false,
	'show_in_admin_bar'   => false,
	'show_in_nav_menus'   => false,
	'can_export'          => false,
	'show_ui'             => true,
	'query_var'           => false,
	'has_archive'         => false,
	'rewrite'             => false,
	'capability_type'     => $cap,
	'capabilities'        => [
		'create_posts'     => "create_{$cap}s",
		'delete_posts'     => "delete_{$cap}s",
		'upload_files_cpt' => "upload_files_{$cap}",
	],
	'map_meta_cap'        => true,
	'hierarchical'        => false,
	'menu_position'       => null,
	'menu_icon'           => 'dashicons-media-text',
	'supports'            => [
		'title',
		'revisions',
		'editor',
		'excerpt',
	],
	'show_in_rest'        => true,
] );

register_post_type( nisje_get_setting( 'post_type_name', 'alerts' ), $args ); // phpcs:ignore
