<?php
/**
 * Setup Type
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

$taxonomy_type = nisje_get_setting( 'taxonomy_type_name', 'nb_library' );

$args = apply_filters( 'nisje_taxononmy_nb_library_type_args', [
	'labels'            => [
		'name'          => esc_html_x( 'Library Type', 'taxonomy general name', 'nisje' ),
		'singular_name' => esc_html_x( 'Library Type', 'taxonomy singular name', 'nisje' ),
		'menu_name'     => esc_html__( 'Library Type', 'nisje' ),
	],
	'hierarchical'      => false,
	'show_admin_column' => false,
	'show_ui'           => false,
	'query_var'         => false,
	'rewrite'           => false,
	'show_in_rest'      => false,
] );

register_taxonomy( $taxonomy_type, null, $args );
