<?php
/**
 * Map library types.
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Map Library types.
 *
 * @param string $type Type.
 * @return array|null Mapped type.
 */
function nisje_nb_map_library_types( string $type ) : ?array {
	global $library_types;

	if ( ! is_array( $library_types ) ) {
		$library_terms = get_terms( nisje_get_setting( 'taxonomy_type_name', 'nb-library' ), [
			'hide_empty' => false,
		] );

		$library_mapping = [
			'AVD'     => 'Avdelinger',
			'FAG'     => 'Fagbibliotek',
			'UTL'     => 'Fagbibliotek',
			'MUS'     => 'Fagbibliotek',
			'ARK'     => 'Fagbibliotek',
			'FIR'     => 'Fagbibliotek',
			'FAG+MUS' => 'Fagbibliotek',
			'ORG'     => 'Fagbibliotek',
			'FAG+VGS' => 'Fagbibliotek',
			'FIL+FEN' => 'Fengselbibliotek',
			'FEN'     => 'Fengselbibliotek',
			'FIL+GSK' => 'Filial',
			'FIL+VGS' => 'Filial',
			'FIL'     => 'Filial',
			'FBI'     => 'Folkebibliotek',
			'FBI+GSK' => 'Folkebibliotek',
			'FBI+VGS' => 'Folkebibliotek',
			'FYB'     => 'Fylkesbibliotek',
			'HØY'     => 'Høgskolebibliotek',
			'BBB'     => 'Mobile bibliotek',
			'NAB'     => 'Nasjonalbibliotek',
			'PAS'     => 'Pasientbibliotek',
			'FIL+PAS' => 'Pasientbibliotek',
			'UNB'     => 'Universitetsbibliotek',
			'UNI'     => 'Universitetsbibliotek',
		];

		foreach ( $library_terms as $term ) {
			if ( $term instanceof \WP_Term ) {
				$mapped_term = isset( $library_mapping[ $term->name ] ) ? $library_mapping[ $term->name ] : null;
				if ( $mapped_term ) {
					$sanitized_key = sanitize_key( $mapped_term );

					if ( ! isset( $library_types[ $sanitized_key ] ) ) {
						$library_types[ $sanitized_key ]['label'] = $mapped_term;
						$library_types[ $sanitized_key ]['key']   = $term->name;
					}

					$library_types[ $sanitized_key ]['slug'][] = $term->slug;
				}
			}
		}
	}

	if ( 'all' === $type ) {
		return $library_types;
	}

	if ( isset( $library_types[ $type ] ) ) {
		return $library_types[ $type ];
	}

	return null;
}

/**
 * Map Library types.
 *
 * @param string $type Type.
 * @return array|null Slugs.
 */
function nisje_nb_get_library_type_slugs( string $type ) : ?array {
	$library_type = nisje_nb_map_library_types( $type );
	if ( $library_type ) {
		return $library_type['slug'];
	}

	return null;
}
