<?php
/**
 * Plugin Name: Nisje - Nasjonalbiblioteket
 * Description: Functionality for Nasjonalbiblioteket
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     9.8.1
 * Text Domain: nisje
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_NB_VERSION', '9.8.1' );

/**
 * Include plugin components
 */
function nisje_nb_include() {
	if ( ! function_exists( 'bp_is_active' ) || ! bp_is_active( 'groups' ) ) {
		return;
	}

	// Filters.
	require __DIR__ . '/filters.php';

	// Shared.
	require __DIR__ . '/shared/library-types.php';

	// Components.
	require __DIR__ . '/components/nb-library/nb-library.php';

	$current_plugin_version = NISJE_NB_VERSION;
	$version_option_key     = 'nisje_nb_version';
	$installed_version      = get_option( $version_option_key );
}
add_action( 'nisje_include', 'nisje_nb_include' );

/**
 * Assets
 */
function nisje_nb_assets() {
	wp_enqueue_script( 'nisje-plugin-bibliotekutvikling' );
	wp_enqueue_style( 'nisje-plugin-bibliotekutvikling' );
}
add_action( 'wp_enqueue_scripts', 'nisje_nb_assets', 20 );

// BuddyPress.
require __DIR__ . '/xprofile/register.php';
