jQuery(function ($) {
	var $test = $('#biblioteksutvikling-library-select').select2({
		language: {
			errorLoading: function () {
				return 'Kunne ikke hente resultater.';
			},
			inputTooShort: function () {
				return 'Start å skrive for å søke etter bibliotek';
			},
			loadingMore: function () {
				return 'Laster flere resultater…';
			},
			noResults: function () {
				return 'Ingen treff';
			},
			searching: function () {
				return 'Søker…';
			},
		},
		ajax: {
			url: '/wp-json/dekode-intranet/v1/groups',
			dataType: 'json',
			delay: 250,
			headers: {
				Authorization: 'Bearer ' + bibToken,
			},
			data: function (params) {
				return {
					context: 'list',
					group_type: 'library',
					per_page: 10,
					search: params.term,
				};
			},
			processResults: function (data) {
				var options = [];
				if (data) {
					// data is the array of arrays, and each of them contains ID and the Label of the option
					$.each(data, function (index, group) {
						options.push({
							id: group.id,
							text: wp.htmlEntities.decodeEntities(group.name),
						});
					});
				}

				return {
					results: options,
				};
			},
			cache: true,
		},
		minimumInputLength: 1,
		placeholder: 'Velg bibliotek',
	});
});
