<?php // phpcs:ignore
/**
 * Library XProfile Class.
 *
 * @package Nisje
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( '\BP_XProfile_Field_Type' ) ) {
	return;
}

/**
 * Group selectbox xprofile field type.
 */
class NB_XProfile_Field_Type_Library_Selectbox extends BP_XProfile_Field_Type {
	/**
	 * Constructor for the library field type.
	 */
	public function __construct() {
		parent::__construct();
		$this->category = _x( 'Groups', 'xprofile field type category', 'nisje' );
		$this->name     = _x( 'Select library', 'xprofile field type', 'nisje' );
		$this->set_format( '/^.*$/m', 'replace' );
	}

	/**
	 * Output the edit field HTML for this field type.
	 *
	 * @param array $raw_properties Optional key/value array of permitted
	 *                              attributes that you want to add.
	 */
	public function edit_field_html( array $raw_properties = [] ) {
		?>

		<legend id="<?php bp_the_profile_field_input_name(); ?>-1">
			<?php bp_the_profile_field_name(); ?>
			<?php bp_the_profile_field_required_label(); ?>
		</legend>

		<?php
		do_action( bp_get_the_profile_field_errors_action() );

		$id = bp_get_the_profile_field_edit_value();
		?>
		<select id="biblioteksutvikling-library-select" <?php echo $this->get_edit_field_html_elements(); // phpcs:ignore ?>>
			<?php
			if ( ! empty( $id ) ) {
				$group = groups_get_group( $id );

				printf( '<option value="%s" selected="selected">%s</option>',
					esc_attr( $id ),
					esc_html( $group->name )
				);
			}
			?>
		</select>
		<?php
	}

	/**
	 * Output HTML for this field type on the wp-admin Profile Fields screen.
	 *
	 * @param array $raw_properties Optional key/value array of permitted
	 *                              attributes that you want to add.
	 */
	public function admin_field_html( array $raw_properties = [] ) {} // phpcs:ignore

	/**
	 * This method usually outputs HTML for this field type's children options
	 * on the wp-admin Profile Fields "Add Field" and "Edit Field" screens, but
	 * for this field type, we don't want it, so it's stubbed out.
	 *
	 * @param BP_XProfile_Field $current_field The current profile field on the
	 *                                         add/edit screen.
	 * @param string            $control_type  Optional. HTML input type used to
	 *                                         render the current field's child
	 *                                         options.
	 */
	public function admin_new_field_html( BP_XProfile_Field $current_field, $control_type = '' ) {} // phpcs:ignore
}
