<?php
/**
 * Updates/Setup/Activation
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Setup plugin
 */
function nisje_blogs_in_groups_check() {
	$current_plugin_version = NISJE_BLOGS_IN_GROUPS_VERSION;
	$version_option_key     = 'nisje_blogs_in_groups_version';
	$installed_version      = get_option( $version_option_key );
	$caps_option_key        = 'nisje_blogs_in_groups_caps';
	$caps_exist             = get_option( $caps_option_key );

	// New install.
	if ( ! $installed_version ) {
		update_option( $version_option_key, $current_plugin_version );

		nisje_blogs_in_groups_activation();

		return;
	}

	// Do nothing if $installed_version is >= $plugin_version.
	if ( version_compare( $installed_version, $current_plugin_version, '>=' ) && $caps_exist ) {
		return;
	} else {
		nisje_blogs_in_groups_activation();

		add_action(
			'admin_notices', function () {
				?>
				<div class="notice">
					<p>
						<strong><?php echo esc_html__( 'Nisje Blogs in Groups:', 'nisje-blogs-in-groups' ); ?></strong>
						<?php esc_html_e( 'Plugin updated!', 'nisje-blogs-in-groups' ); ?>
					</p>
				</div>
				<?php
			}
		);
	}
}

add_action( 'nisje_updates', 'nisje_blogs_in_groups_check' );

/**
 * Activation
 */
function nisje_blogs_in_groups_activation() {
	$all_roles          = nisje_get_setting( 'roles', 'core' );
	$version_option_key = 'nisje_blogs_in_groups_version';
	$caps_option_key    = 'nisje_blogs_in_groups_caps';

	nisje_activate_roles( $all_roles, nisje_get_setting( 'capability_key_group', 'blogs' ) );
	update_option( $caps_option_key, true );

	update_option( $version_option_key, NISJE_BLOGS_IN_GROUPS_VERSION );
}
