<?php
/**
 * Plugin Name: Nisje - Blogs in Groups
 * Description: Bring blogs within groups to Nisje.
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     7.1.2
 * Text Domain: nisje-blogs-in-groups
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_BLOGS_IN_GROUPS_VERSION', '7.1.2' );

/**
 * Load plugin textdomain.
 */
function nisje_blogs_in_groups_load_textdomain() {
	load_plugin_textdomain( 'nisje-blogs-in-groups', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_blogs_in_groups_load_textdomain' );

/**
 * Include plugin components
 */
function nisje_blogs_in_groups_include() {
	// Updates.
	require __DIR__ . '/updates.php';
	// Blogs in groups component.
	require __DIR__ . '/blogs-in-groups/blogs-in-groups.php';
}
add_action( 'nisje_include', 'nisje_blogs_in_groups_include' );

/**
 * Registers scripts and styles
 */
function nisje_blogs_register_scripts_and_styles() {
	wp_enqueue_script( 'nisje-plugin-blogs' );
}
add_action( 'wp_enqueue_scripts', 'nisje_blogs_register_scripts_and_styles', 20 );
