<?php
/**
 * Plugin Name: Nisje - Blogs in Groups
 * Description: Bring blogs within groups to Nisje.
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     9.2.0
 * Text Domain: nisje
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_BLOGS_IN_GROUPS_VERSION', '9.2.0' );

/**
 * Include plugin components
 */
function nisje_blogs_in_groups_include() {
	// Updates.
	require __DIR__ . '/updates.php';
	// Blogs in groups component.
	require __DIR__ . '/blogs-in-groups/blogs-in-groups.php';
}
add_action( 'nisje_include', 'nisje_blogs_in_groups_include' );

/**
 * Registers scripts and styles
 */
function nisje_blogs_register_scripts_and_styles() {
	wp_enqueue_script( 'nisje-plugin-blogs' );
}
add_action( 'wp_enqueue_scripts', 'nisje_blogs_register_scripts_and_styles', 20 );
