<?php
/**
 * Plugin Name: Nisje - Frontpage Bookmarks
 * Description: Add User and Predefined Bookmarks to the Frontpage as a card
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     6.0.0
 * Text Domain: nisje-bookmarks
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_BOOKMARKS_VERSION', '6.0.0' );

/**
 * Load plugin textdomain.
 */
function nisje_bookmarks_load_textdomain() {
	load_plugin_textdomain( 'nisje-bookmarks', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_bookmarks_load_textdomain' );

/**
 * Extend User Endpoints with Bookmarks.
 */
function nisje_bookmarks_extend_user_route() {
	$key = 'nisje_user_bookmarks';

	register_rest_field( 'user', 'bookmarks', [
		'get_callback'    => function( $object ) use ( $key ) {
			$retval = [];

			$bookmarks = get_user_meta( $object['id'], $key, true );
			if ( is_array( $bookmarks ) && ! empty( $bookmarks ) ) {
				$retval = $bookmarks;
			}

			return $retval;
		},
		'update_callback' => function( $value, $user ) use ( $key ) {
			update_user_meta( $user->ID, $key, $value );

			return $value;
		},
		'schema'          => [
			'context'     => [ 'edit' ],
			'description' => esc_html__( 'Array of user bookmarks', 'nisje-bookmarks' ),
			'type'        => 'array',
			'items'       => [
				'type'       => 'object',
				'properties' => [
					'link'  => [
						'context'     => [ 'edit' ],
						'description' => esc_html__( 'The link.', 'nisje-bookmarks' ),
						'type'        => 'string',
						'required'    => true,
					],
					'title' => [
						'context'     => [ 'edit' ],
						'description' => esc_html__( 'Title of the link', 'nisje-bookmarks' ),
						'type'        => 'string',
						'required'    => true,
					],
				],
			],
		],
	] );
}
add_action( 'nisje_register_rest_routes', 'nisje_bookmarks_extend_user_route' );

/**
 * Add User bookmark layout
 */
function nisje_register_bookmarks_layout() {
	if ( ! function_exists( 'nisje_fpl_register_layout' ) ) {
		return;
	}

	nisje_fpl_register_layout(
		'user_bookmark', [
			'key'        => '5b684df2rf573e',
			'label'      => esc_html__( 'User Bookmarks', 'nisje-bookmarks' ),
			'sub_fields' => [
				[
					'key'          => 'field_5b684e15kf741',
					'label'        => esc_html__( 'Links', 'nisje-bookmarks' ),
					'name'         => 'links',
					'type'         => 'repeater',
					'instructions' => esc_html__( 'Add custom links to this card.', 'nisje-bookmarks' ),
					'button_label' => esc_html__( 'Add Link', 'nisje-bookmarks' ),
					'sub_fields'   => [
						[
							'key'      => 'field_5b68put52f742',
							'label'    => esc_html__( 'Link Title', 'nisje-bookmarks' ),
							'name'     => 'title',
							'type'     => 'text',
							'required' => 1,
						],
						[
							'key'      => 'field_5b684qdg2f743',
							'label'    => esc_html__( 'Link URL', 'nisje-bookmarks' ),
							'name'     => 'link',
							'type'     => 'url',
							'required' => 1,
						],
					],
				],
				[
					'key'          => 'field_5b685efhf9f4e',
					'label'        => esc_html__( 'Position', 'nisje-bookmarks' ),
					'name'         => 'position',
					'type'         => 'number',
					'instructions' => esc_html__( 'Add the position in the feed you\'d like this card to be injected after.', 'nisje-bookmarks' ),
					'required'     => 1,
				],
			],
		]
	);
}
add_action( 'nisje_fpl_register_layouts', 'nisje_register_bookmarks_layout' );
