<?php
/**
 * Setup Connect Wiki Component
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Components;

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! class_exists( '\\Dekode\\Nisje\\Components\\Connect_Wiki' ) && class_exists( '\\Dekode\\Nisje\\Components\\Component' ) ) {

	/**
	 * Connect Wiki Component Class
	 */
	class Connect_Wiki extends Component {
		/**
		 * Constructor
		 */
		public function __construct() {
			$path = trailingslashit( dirname( __FILE__ ) );

			parent::start(
				'connect-wiki',
				esc_html__( 'Connect Wiki', 'nisje-connect-wiki' ),
				$path
			);
		}

		/**
		 * Includes
		 */
		public function includes() {
			$this->include_file( 'helper-functions.php' );
		}

		/**
		 * Global variables
		 */
		public function setup_globals() {
			$this->settings = [
				// Public.
				'capability_key' => 'nisje_connect_wiki',
			];
		}

		/**
		 * Add frontend options
		 *
		 * @param array $options Options.
		 */
		public function add_frontend_option( $options ) {
			$options['features']['groupConnectedWiki'] = true;
			return $options;
		}

		/**
		 * Set up filters and actions
		 */
		public function setup_filters() {
			add_filter( 'nisje_frontend_options', [ $this, 'add_frontend_option' ] );
		}

		/**
		 * Register public settings.
		 */
		public function register_public_settings() {
			$this->public_settings = [
				'wiki_categories' => nisje_get_public_wiki_categories(),
			];
		}

		/**
		 * Register REST Endpoints
		 */
		public function register_rest_routes() {
			$this->include_file( 'rest-handlers/extend-groups.php' );
		}
	}
}
