<?php
/**
 * Plugin Name: Nisje - Connect Wiki to Group
 * Description: Allow public Wiki categories to be attached to Groups.
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     7.0.0
 * Text Domain: nisje-connect-wiki
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_CONNECTED_WIKI', '5.1.0' );

/**
 * Load plugin textdomain.
 */
function nisje_connect_wiki_load_textdomain() {
	load_plugin_textdomain( 'nisje-connect-wiki', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_connect_wiki_load_textdomain' );

/**
 * Include plugin components
 */
function nisje_connect_wiki_include() {
	require __DIR__ . '/connect-wiki/connect-wiki.php';
}
add_action( 'nisje_include', 'nisje_connect_wiki_include', 11 );
