<?php
/**
 * Extend Groups with public Wiki categories connection field.
 *
 * @package Nisje
 */

$endpoint  = strtolower( buddypress()->groups->id );
$field_key = '_connected_wiki_cats';

$option_field_key = '_nisje_connect_wiki_enabled';

// Enable connect wiki.
register_rest_field(
	$endpoint, 'enable_connect_wiki', [
		'get_callback'    => function ( $object ) use ( $option_field_key ) {
			$group_id = $object['id'];
			return (bool) groups_get_groupmeta( $group_id, $option_field_key, true );
		},
		'update_callback' => function ( $value, $object ) use ( $option_field_key ) {
			$group_id = $object->id;
			if ( isset( $value ) ) {
				return groups_update_groupmeta( $group_id, $option_field_key, $value );
			}
		},
		'schema'          => [
			'context'     => [ 'view', 'edit', 'member' ],
			'description' => esc_html__( 'Whether the connect wiki feature is enabled or not.', 'nisje-connect-wiki' ),
			'type'        => 'boolean',
		],
	]
);

// Wiki categories.
register_rest_field(
	$endpoint, 'wiki_categories', [
		'get_callback'    => function ( $object ) use ( $field_key ) {
			$retval   = [];
			$group_id = $object['id'];

			if ( groups_get_groupmeta( $group_id, $field_key ) ) {
				$retval = [ groups_get_groupmeta( $group_id, $field_key ) ];
			}

			return $retval;
		},
		'update_callback' => function ( $value, $object ) use ( $field_key ) {
			$group_id = $object->id;

			// Check for null value (no wiki option).
			if ( 0 === intval( $value['term_id'] ) ) {
				if ( ! groups_add_groupmeta( $group_id, $field_key, $value, true ) ) {
					return groups_update_groupmeta( $group_id, $field_key, $value );
				}
			}

			// Validate wiki category id.
			$all_wiki_category_ids = nisje_get_public_wiki_categories_ids();
			if ( ! in_array( intval( $value['term_id'] ), $all_wiki_category_ids, true ) ) {
				return false;
			}
			if ( ! groups_add_groupmeta( $group_id, $field_key, $value, true ) ) {
				return groups_update_groupmeta( $group_id, $field_key, $value );
			}
		},
		'schema'          => [
			'context'     => [ 'view', 'edit', 'member' ],
			'description' => esc_html__( 'IDs of public Wiki categories', 'nisje-connect-wiki' ),
			'type'        => 'object',
			'items'       => [
				'type' => 'object',
			],
			'readonly'    => false,
		],
	]
);
