<?php
/**
 * Plugin Name: Nisje - CSSR
 * Description: Functionality for CSSR
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     7.0.2
 * Text Domain: nisje-css
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_CSSR_VERSION', '7.0.2' );
define( 'NISJE_CSSR_URL', plugin_dir_url( __FILE__ ) );

require __DIR__ . '/gutenberg.php';

/**
 * Set frontend options for CSSR
 *
 * @param array $options Frontend options.
 */
function nisje_cssr_frontend_options( array $options ): array {
	$options['disabledUserContentTypes'] = [ 'experience', 'social' ];
	$options['groupWikiCap']             = 'member';
	$options['wikiSlug']                 = 'resources';
	return $options;
}
add_filter( 'nisje_frontend_options', 'nisje_cssr_frontend_options' );

/**
 * Optimize wiki slug
 *
 * @param array $settings Post type settings.
 */
function nisje_cssr_wiki_post_type( array $settings ): array {
	$settings['rewrite']['slug'] = 'resources/%post_id%';
	return $settings;
}
add_filter( 'nisje_wiki_post_type_args', 'nisje_cssr_wiki_post_type' );

/**
 * Add roles
 */
register_activation_hook( __FILE__, function() {
	// Make wiki available to subscribers.
	$sub_role = get_role( 'subscriber' );
	$sub_role->add_cap( 'edit_di_wiki' );
	$sub_role->add_cap( 'create_di_wikis' );
} );
add_filter( 'nisje_override_rest_permission_check', '__return_true', 20 );

/**
 * Optimize latest news card
 *
 * @param string $content Content.
 */
function nisje_cssr_news_card_lang( $content ) {
	$lang            = nisje_get_content_language( $content['title'] );
	$content['lang'] = $lang;

	return $content;
}
add_filter( 'nisje_news_card_latest_news_content', 'nisje_cssr_news_card_lang' );
add_filter( 'nisje_news_card_latest_news_content_item', 'nisje_cssr_news_card_lang' );
