<?php
/**
 * Plugin Name: Nisje - Environment
 * Description: Helper plugin for the core packages of Nisje.
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     6.0.0
 * Text Domain: nisje-environment
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Environment;

defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_ENVIRONMENT_VERSION', '6.0.0' );

/**
 * Filters
 */
add_action( 'plugins_loaded', __NAMESPACE__ . '\\load_textdomain' );

/**
 * Load plugin textdomain.
 */
function load_textdomain() {
	load_plugin_textdomain( 'nisje-environment', false, basename( __DIR__ ) . '/languages' );
}
