<?php
/**
 * Setup Event Post Type
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$cap       = nisje_get_setting( 'capability_key', 'event' );
$field_key = nisje_get_setting( 'field_key', 'event' );

$args = apply_filters( 'nisje_event_post_type_args', [
	'labels'                => [
		'name'          => esc_html__( 'Events', 'nisje' ),
		'singular_name' => esc_html__( 'Event', 'nisje' ),
	],
	'public'                => true,
	'publicly_queryable'    => false,
	'exclude_from_search'   => false,
	'show_in_admin_bar'     => false,
	'show_in_nav_menus'     => false,
	'can_export'            => false,
	'show_ui'               => false,
	'query_var'             => false,
	'has_archive'           => false,
	'rewrite'               => false,
	'capability_type'       => $cap,
	'capabilities'          => [
		'create_posts'     => "create_{$cap}s",
		'delete_posts'     => "delete_{$cap}s",
		'upload_files_cpt' => "upload_files_{$cap}",
	],
	'map_meta_cap'          => true,
	'hierarchical'          => false,
	'menu_position'         => null,
	'menu_icon'             => 'dashicons-media-text',
	'supports'              => [
		'title',
		'revisions',
		'editor',
		'comments',
		'thumbnail',
		'author',
		'excerpt',
	],
	'show_in_rest'          => true,
	'rest_base'             => nisje_get_setting( 'post_type_rest_endpoint', 'event' ),
	'rest_controller_class' => 'WP_REST_Posts_Controller',
] );

register_post_type( nisje_get_setting( 'post_type_name', 'event' ), $args );
