<?php
/**
 * Extend BuddyPress groups
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Group news
 */
register_rest_field( 'bp_groups', 'enable_event', [
	'get_callback' => function( $object ) {
		return (bool) \groups_get_groupmeta( $object['id'], '_nisje_event_enabled', true );
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => esc_html__( 'Is group events enabled', 'nisje' ),
		'type'        => 'bool',
		'readonly'    => true,
	],
] );
