<?php
/**
 * Plugin Name: Nisje - Event
 * Description: Add a events to Nisje
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     7.7.4
 * Text Domain: nisje
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );

defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_EVENT_VERSION', '7.7.4' );

/**
 * Include plugin components
 */
function nisje_event_include() {
	require __DIR__ . '/event/event.php';
}
add_action( 'nisje_include', 'nisje_event_include' );

/**
 * Registers scripts and styles
 */
function nisje_events_register_scripts_and_styles() {
	wp_enqueue_script( 'nisje-plugin-events' );
	wp_enqueue_style( 'nisje-plugin-events' );
}
add_action( 'wp_enqueue_scripts', 'nisje_events_register_scripts_and_styles', 20 );
