<?php
/**
 * Plugin Name: Nisje - Feed Layouts
 * Description: Allows creation of custom feed layouts in Nisje.
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     8.0.5
 * Text Domain: nisje
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );

namespace Nisje\FeedLayouts;

use function Nisje\FeedLayouts\Helpers\{
	get_frontpage_id,
	get_group_ids
};

defined( 'ABSPATH' ) || die( 'Shame on you' );
define( 'NISJE_FEEDLAYOUTS_VERSION', '8.0.5' );

require __DIR__ . '/inc/post-types.php';
require __DIR__ . '/inc/assets.php';
require __DIR__ . '/inc/helper-functions.php';

/**
 * Add frontpage id to options.
 *
 * @param array $options Frontend DOM options.
 */
function add_frontend_options( array $options ): array {
	$options['feedLayouts']['frontpage'] = get_frontpage_id();
	$options['feedLayouts']['groups']    = get_group_ids();
	return $options;
}
\add_filter( 'nisje_frontend_options', __NAMESPACE__ . '\\add_frontend_options' );

/**
 * Filter card to get correct group posts in group front pages.
 *
 * @param array     $args  The rest api fetch args.
 * @param \WP_Block $block The block.
 */
function group_cards( array $args, \WP_Block $block ) {
	if ( ! isset( $block->context['postId'] ) || ! isset( $block->context['postType'] ) || 'nisje-feed-group' !== $block->context['postType'] ) {
		return $args;
	}

	$group_id = \get_post_meta( $block->context['postId'], 'group_id', true );

	if ( $group_id ) {
		$args['group_id'] = $group_id;
	}

	return $args;
}
\add_filter( 'nisje_block_library_user_content_card_args', __NAMESPACE__ . '\\group_cards', 10, 2 );
\add_filter( 'nisje_block_library_card_latest_args', __NAMESPACE__ . '\\group_cards', 10, 2 );
\add_filter( 'nisje_block_library_feed_infinite_args', __NAMESPACE__ . '\\group_cards', 10, 2 );
