<?php
/**
 * Setup Front Page Feed Post Type
 *
 * @package Nisje
 */

namespace Nisje\FeedLayouts\PostTypes;

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Register Feed Layout post types
 */
function register_post_types() {
	/**
	 * Front pages.
	 */
	\register_post_type( 'nisje-feed-frontpage', [
		'labels'              => [
			'name'          => \esc_html__( 'Front Pages', 'nisje' ),
			'singular_name' => \esc_html__( 'Front Page', 'nisje' ),
		],
		'public'              => true,
		'publicly_queryable'  => true,
		'exclude_from_search' => false,
		'show_in_admin_bar'   => false,
		'show_in_nav_menus'   => true,
		'can_export'          => false,
		'show_ui'             => true,
		'query_var'           => false,
		'has_archive'         => false,
		'rewrite'             => false,
		'map_meta_cap'        => true,
		'hierarchical'        => false,
		'menu_position'       => 5,
		'menu_icon'           => 'dashicons-admin-home',
		'show_in_rest'        => true,
		'rewrite'             => [
			'slug'       => 'feed-layout/%post_id%',
			'with_front' => false,
		],
		'supports'            => [
			'title',
			'editor',
			'revisions',
			'custom-fields',
		],
	] );

	\register_post_meta( 'nisje-feed-frontpage', 'member_type', [
		'show_in_rest' => true,
		'single'       => true,
		'type'         => 'string',
	] );

	/**
	 * Group front pages.
	 */
	if ( function_exists( '\bp_is_active' ) && \bp_is_active( 'groups' ) ) {
		\register_post_type( 'nisje-feed-group', [
			'labels'              => [
				'name'          => \esc_html__( 'Group Pages', 'nisje' ),
				'singular_name' => \esc_html__( 'Group Page', 'nisje' ),
			],
			'public'              => false,
			'publicly_queryable'  => false,
			'exclude_from_search' => false,
			'show_in_admin_bar'   => false,
			'show_in_nav_menus'   => true,
			'can_export'          => false,
			'show_ui'             => true,
			'query_var'           => false,
			'has_archive'         => false,
			'rewrite'             => false,
			'map_meta_cap'        => true,
			'hierarchical'        => false,
			'menu_position'       => 6,
			'menu_icon'           => 'dashicons-buddicons-groups',
			'show_in_rest'        => true,
			'supports'            => [
				'title',
				'editor',
				'revisions',
				'custom-fields',
			],
		] );

		\register_post_meta( 'nisje-feed-group', 'group_id', [
			'show_in_rest' => true,
			'single'       => true,
			'type'         => 'string',
		] );
	}
}

\add_action( 'init', __NAMESPACE__ . '\\register_post_types' );
