<?php
/**
 * Setup Front Page Feed Post Type
 *
 * @package Nisje
 */

namespace Nisje\FeedLayouts\Assets;

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Editor mods
 */
function editor_assets() {
	$current_screen = get_current_screen();

	if ( 'nisje-feed-frontpage' === $current_screen->post_type || 'nisje-feed-group' === $current_screen->post_type ) {
		$options = [];

		if ( 'nisje-feed-frontpage' === $current_screen->post_type ) {
			$member_types_options = [];

			if ( function_exists( 'bp_get_member_types' ) ) {
				$member_types = \bp_get_member_types( [], 'object' );

				if ( $member_types ) {
					foreach ( $member_types as $key => $member_type ) {
						$member_types_options[] = [
							'label' => $member_type->labels['name'] ?: $key,
							'value' => $key,
						];
					}
				}
			}

			$options['memberTypes'] = $member_types_options;
		}

		if ( 'nisje-feed-group' === $current_screen->post_type ) {
			$group_options = [];

			if ( function_exists( 'groups_get_groups' ) ) {
				$user_groups = \groups_get_groups(
					[
						'type'        => 'alphabetical',
						'per_page'    => 999,
						'show_hidden' => true,
					]
				);

				if ( isset( $user_groups['groups'] ) ) {
					foreach ( $user_groups['groups'] as $group ) {
						$group_options[] = [
							'label' => html_entity_decode( $group->name ),
							'value' => $group->id,
						];
					}
				}
			}

			$options['groups'] = $group_options;
		}

		\wp_enqueue_script( 'nisje-plugin-feed-layouts-admin' );

		\wp_add_inline_script(
			'nisje-plugin-feed-layouts-admin',
			sprintf(
				'var nisjeFeedLayoutSettings = %s;',
				wp_json_encode( $options )
			),
			'before'
		);
	}
}

\add_action( 'enqueue_block_editor_assets', __NAMESPACE__ . '\\editor_assets', 20 );

/**
 * Enqueue scripts and styles
 */
function assets() {
	wp_enqueue_script( 'nisje-plugin-feed-layouts' );
}
\add_action( 'wp_enqueue_scripts', __NAMESPACE__ . '\\assets', 20 );
