<?php
/**
 * Helper functions for Feed layouts
 *
 * @package Nisje
 */

namespace Nisje\FeedLayouts\Helpers;

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Get frontpage id based on membertype
 */
function get_frontpage_id() {
	$id = 0;

	if ( ! is_user_logged_in() || ! function_exists( 'bp_get_member_type' ) ) {
		return $id;
	}

	$member_type = \bp_get_member_type( \get_current_user_id() );

	$args = [
		'post_type'      => 'nisje-feed-frontpage',
		'fields'         => 'ids',
		'posts_per_page' => 1,
		'orderby'        => 'menu_order date',
	];

	if ( ! $member_type ) {
		$args['meta_query'] = [ // phpcs:ignore
			'relation' => 'OR',
			[
				'key'     => 'member_type',
				'compare' => 'NOT EXISTS',
			],
			[
				'key'     => 'member_type',
				'value'   => '',
				'compare' => 'LIKE',
			],
		];
	} else {
		$args['meta_key']   = 'member_type'; // phpcs:ignore
		$args['meta_value'] = $member_type; // phpcs:ignore
	}

	$the_query = new \WP_Query( $args );

	if ( $the_query->have_posts() ) {
		while ( $the_query->have_posts() ) {
			$the_query->the_post();
			$id = get_the_ID();
		}
	}

	return $id;
}

/**
 * Get frontpage ids based on groups
 */
function get_group_ids() {
	$ids = [];

	$the_query = new \WP_Query( [
		'post_type'      => 'nisje-feed-group',
		'fields'         => 'ids',
		'posts_per_page' => -1,
	] );

	if ( $the_query->have_posts() ) {
		while ( $the_query->have_posts() ) {
			$the_query->the_post();

			$group = \get_post_meta( \get_the_ID(), 'group_id', true );

			if ( $group ) {
				$ids[ $group ] = get_the_ID();
			}
		}
	}

	return $ids;
}
