<?php
/**
 * Tweets layout.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! function_exists( 'nisje_fpl_register_layout' ) ) {
	return;
}

nisje_fpl_register_layout(
	'tweet', [
		'key'        => '5b684ec02f744',
		'label'      => esc_html__( 'Tweet Card', 'nisje-fpl' ),
		'sub_fields' => [
			[
				'key'       => 'field_5b684eca2f749',
				'label'     => '',
				'name'      => '',
				'type'      => 'message',
				'message'   => esc_html__( 'This card will show the latest Tweet from the account specified.', 'nisje-fpl' ),
				'new_lines' => 'wpautop',
				'esc_html'  => 0,
			],
			[
				'key'          => 'field_5b7409b1f2dbb',
				'label'        => esc_html__( 'Username', 'nisje-fpl' ),
				'name'         => 'username',
				'type'         => 'text',
				'instructions' => '',
				'required'     => 1,
			],
			[
				'key'               => 'field_5b684ef32f74c',
				'label'             => esc_html__( 'Columns', 'nisje-fpl' ),
				'name'              => 'columns',
				'type'              => 'radio',
				'instructions'      => esc_html__( 'Choose the number of columns this card will span across.', 'nisje-fpl' ),
				'required'          => 1,
				'choices'           => [
					1 => '1',
					3 => '3',
				],
				'allow_null'        => 0,
				'other_choice'      => 0,
				'save_other_choice' => 0,
				'default_value'     => 1,
				'layout'            => 'horizontal',
				'return_format'     => 'value',
			],
			[
				'key'           => 'field_5b685644f9f4f',
				'label'         => esc_html__( 'Position', 'nisje-fpl' ),
				'name'          => 'position',
				'type'          => 'number',
				'instructions'  => esc_html__( 'Add the position in the feed you\'d like this card to be injected after.', 'nisje-fpl' ),
				'required'      => 1,
				'default_value' => 0,
			],
		],
	]
);
