<?php
/**
 * Plugin Name: Nisje - Front Page Layouts
 * Description: Allows creation of custom front page layouts in Nisje.
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     7.3.0
 * Text Domain: nisje-fpl
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_FPL_VERSION', '7.3.0' );

/**
 * Load plugin textdomain.
 */
function nisje_fpl_load_textdomain() {
	load_plugin_textdomain( 'nisje-fpl', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_fpl_load_textdomain' );

/**
 * Include plugin components
 */
function nisje_fpl_include() {
	require __DIR__ . '/updates.php';
	require __DIR__ . '/front-page-layouts/front-page-layouts.php';
}
add_action( 'nisje_include', 'nisje_fpl_include' );
