<?php
/**
 * ACF field group front page layouts
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! function_exists( 'acf_add_local_field_group' ) ) {
	return;
}

$rendered_layouts = [];

$layouts = nisje_flp_get_all_registered_layouts();

foreach ( $layouts as $layout ) {
	$rendered_layouts[ $layout->key ] = [
		'key'        => $layout->key,
		'name'       => $layout->name,
		'label'      => $layout->label,
		'display'    => $layout->display,
		'sub_fields' => $layout->sub_fields,
		'min'        => $layout->min,
		'max'        => $layout->max,
	];
}

acf_add_local_field_group(
	[
		'key'                   => 'group_5b4f47113c3ea',
		'title'                 => esc_html__( 'Front Page Layouts', 'nisje-fpl' ),
		'fields'                => [
			[
				'key'          => 'field_5b681632b08a1',
				'label'        => esc_html__( 'Cards', 'nisje-fpl' ),
				'name'         => 'cards',
				'type'         => 'flexible_content',
				'instructions' => esc_html__( 'Add a number of cards to create a custom front page layout.', 'nisje-fpl' ),
				'layouts'      => $rendered_layouts,
				'button_label' => esc_html__( 'Add Card', 'nisje-fpl' ),
			],
		],
		'location'              => [
			[
				[
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'nisje-fpls',
				],
			],
			[
				[
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'nisje-fpls-group',
				],
			],
		],
		'menu_order'            => 0,
		'position'              => 'normal',
		'style'                 => 'default',
		'label_placement'       => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen'        => '',
		'active'                => 1,
		'description'           => '',
	]
);
