<?php
/**
 * User content layout.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! function_exists( 'nisje_fpl_register_layout' ) ) {
	return;
}

$post_types = apply_filters(
	'nisje_fpl_user_content_post_types', [
		0 => 'nisje-user-content',
	]
);

$taxonomies = apply_filters( 'nisje_fpl_user_content_taxonomies', [] );

nisje_fpl_register_layout(
	'user_content', [
		'key'        => '5b684c842f73c',
		'label'      => esc_html__( 'User Content Card', 'nisje-fpl' ),
		'sub_fields' => [
			[
				'key'           => 'field_5b684c842f73d',
				'label'         => esc_html__( 'Post', 'nisje-fpl' ),
				'name'          => 'post',
				'type'          => 'relationship',
				'instructions'  => esc_html__( 'Pick a post for this card to show.', 'nisje-fpl' ),
				'required'      => 1,
				'post_type'     => $post_types,
				'taxonomy'      => $taxonomies,
				'filters'       => [
					0 => 'search',
					1 => 'taxonomy',
				],
				'elements'      => [
					0 => 'featured_image',
				],
				'min'           => 1,
				'max'           => 1,
				'return_format' => 'object',
			],
			[
				'key'           => 'field_5b68561bf9f4c',
				'label'         => esc_html__( 'Position', 'nisje-fpl' ),
				'name'          => 'position',
				'type'          => 'number',
				'instructions'  => esc_html__( 'Add the position in the feed you\'d like this card to be injected after.', 'nisje-fpl' ),
				'required'      => 1,
				'default_value' => 0,
			],
		],
	]
);
