<?php
/**
 * Layouts object class
 *
 * @package Nisje
 */

/**
 * Class representing a layout
 */
class FPL_Layout {
	/**
	 * Name
	 *
	 * @var string
	 */
	public $name;

	/**
	 * Layout
	 *
	 * @var array
	 */
	public $layout;

	/**
	 * Content callback.
	 *
	 * @var callable
	 */
	public $render_callback;

	/**
	 * Constructor.
	 *
	 * Will populate object properties from the provided arguments.
	 *
	 * @param string $name Layout name.
	 * @param array  $args Optional args.
	 */
	public function __construct( $name, $args = [] ) {
		$this->name = $name;

		$this->set_props( $args );
	}

	/**
	 * Renders the layout.
	 *
	 * @return string Rendered layout type output.
	 */
	public function render() {
		if ( ! $this->is_dynamic() ) {
			return '';
		}

		return (string) call_user_func( $this->render_callback );
	}

	/**
	 * Returns true if the layout is dynamic, or false otherwise. A dynamic
	 * layout is one which defers its rendering to occur on-demand at runtime.
	 *
	 * @return boolean Whether layout type is dynamic.
	 */
	public function is_dynamic() {
		return is_callable( $this->render_callback );
	}

	/**
	 * Sets layout props.
	 *
	 * @param array $args Array of arguments.
	 */
	public function set_props( $args ) {
		$args = wp_parse_args(
			$args, [
				'render_callback' => null,
				'sub_fields'      => [],
				'key'             => '',
				'min'             => 0,
				'max'             => 0,
				'display'         => 'block',
				'label'           => '',
			]
		);

		$args['name'] = $this->name;

		foreach ( $args as $property_name => $property_value ) {
			$this->$property_name = $property_value;
		}
	}
}
