<?php
/**
 * Updates/Setup/Activation
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Setup plugin
 */
function nisje_fpl_check() {
	$current_plugin_version = NISJE_FPL_VERSION;
	$version_option_key     = 'nisje_fpl_version';
	$installed_version      = get_option( $version_option_key );

	// New install.
	if ( ! $installed_version ) {
		update_option( $version_option_key, $current_plugin_version );

		nisje_fpl_activation();

		return;
	}

	// Do nothing if $installed_version is >= $plugin_version.
	if ( version_compare( $installed_version, $current_plugin_version, '>=' ) ) {
		return;
	} else {
		nisje_fpl_activation();

		add_action(
			'admin_notices', function () {
				?>
				<div class="notice">
					<p>
						<strong><?php echo esc_html__( 'Nisje Front Page Layouts:', 'nisje-fpl' ); ?></strong>
						<?php esc_html_e( 'Plugin updated!', 'nisje-fpl' ); ?>
					</p>
				</div>
				<?php
			}
		);
	}
}
add_action( 'nisje_updates', 'nisje_fpl_check' );

/**
 * Activation
 */
function nisje_fpl_activation() {
	$version_option_key = 'nisje_fpl_version';
	$all_roles          = nisje_get_setting( 'roles', 'core' );

	nisje_activate_roles( $all_roles, nisje_get_setting( 'capability_key', 'front-page-layouts' ) );
	nisje_activate_roles( $all_roles, nisje_get_setting( 'capability_key_group', 'front-page-layouts' ) );

	update_option( $version_option_key, NISJE_FPL_VERSION );
}
