<?php
/**
 * Extend Groups Endpoint with Group Front Page Layout Fields
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$endpoint = strtolower( buddypress()->groups->id );

register_rest_field(
	$endpoint, 'front_page_layouts', [
		'get_callback' => function( $object ) {
			return nisje_fpl_build_layouts( $object['id'] );
		},
		'schema'       => [
			'context'     => [ 'view', 'member' ],
			'description' => esc_html__( 'Collection of Front Page Layout fields', 'nisje-fpl' ),
			'type'        => 'array',
			'items'       => [
				'type'       => 'object',
				'context'    => [ 'view', 'member' ],
				'properties' => [
					'id'    => [
						'description' => esc_html__( 'ID for the layout.', 'nisje-fpl' ),
						'type'        => 'integer',
						'context'     => [ 'view', 'member' ],
						'readonly'    => true,
					],
					'cards' => [
						'description' => esc_html__( 'Cards within the layout.', 'nisje-fpl' ),
						'type'        => 'object',
						'context'     => [ 'view', 'member' ],
						'readonly'    => true,
					],
				],
			],
		],
	]
);
