<?php
/**
 * ACF field group front page layout users not logged in.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! function_exists( 'acf_add_local_field_group' ) ) {
	return;
}

acf_add_local_field_group(
	[
		'key'                   => 'group_5c541b5f6a271',
		'title'                 => esc_html__( 'Not logged in', 'nisje-fpl' ),
		'fields'                => [
			[
				'key'           => 'field_5c541b62be3b8',
				'label'         => esc_html__( 'Is this a frontpage for users not logged in?', 'nisje-fpl' ),
				'name'          => 'not_logged_in',
				'type'          => 'true_false',
				'required'      => 0,
				'message'       => '',
				'default_value' => 0,
				'ui'            => 0,
				'ui_on_text'    => '',
				'ui_off_text'   => '',
			],
		],
		'location'              => [
			[
				[
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'nisje-fpls',
				],
			],
		],
		'menu_order'            => 0,
		'position'              => 'side',
		'style'                 => 'default',
		'label_placement'       => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen'        => '',
		'active'                => 1,
		'description'           => '',
	]
);
