<?php
/**
 * Latest Card layout.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! function_exists( 'nisje_fpl_register_layout' ) ) {
	return;
}

$post_types = apply_filters(
	'nisje_fpl_latest_post_types', [
		'events' => esc_html__( 'Events', 'nisje-fpl' ),
		'news'   => esc_html__( 'News', 'nisje-fpl' ),
		'wiki'   => esc_html__( 'Wiki', 'nisje-fpl' ),
	]
);

nisje_fpl_register_layout(
	'latest', [
		'key'        => '5b68163e93283',
		'label'      => esc_html__( 'Latest Card', 'nisje-fpl' ),
		'sub_fields' => [
			[
				'key'           => 'field_4lchgc77kLbjt',
				'label'         => esc_html__( 'Custom title', 'nisje-fpl' ),
				'name'          => 'title',
				'type'          => 'text',
				'instructions'  => esc_html__( 'Overwrite the title with your own custom one.', 'nisje-fpl' ),
				'required'      => 0,
				'default_value' => '',
			],
			[
				'key'               => 'field_5b681662b08a2',
				'label'             => 'Post Type',
				'name'              => 'post_type',
				'type'              => 'radio',
				'instructions'      => esc_html__( 'From what post type should this card display the latest posts?', 'nisje-fpl' ),
				'required'          => 1,
				'choices'           => $post_types,
				'allow_null'        => 0,
				'other_choice'      => 0,
				'save_other_choice' => 0,
				'default_value'     => 'news',
				'layout'            => '',
				'return_format'     => '',
			],
			[
				'key'               => 'field_5b681698b08a3',
				'label'             => esc_html__( 'Number of Posts', 'nisje-fpl' ),
				'name'              => 'number_of_posts',
				'type'              => 'radio',
				'instructions'      => esc_html__( 'How many posts should this card show?', 'nisje-fpl' ),
				'required'          => 1,
				'choices'           => [
					3 => '3',
					4 => '4',
					5 => '5',
				],
				'allow_null'        => 0,
				'other_choice'      => 0,
				'save_other_choice' => 0,
				'default_value'     => 3,
				'layout'            => '',
				'return_format'     => '',
			],
			[
				'key'           => 'field_5b6855f4f9f4b',
				'label'         => esc_html__( 'Position', 'nisje-fpl' ),
				'name'          => 'position',
				'type'          => 'number',
				'instructions'  => esc_html__( 'Add the position in the feed you\'d like this card to be injected after.', 'nisje-fpl' ),
				'required'      => 1,
				'default_value' => 0,
			],
		],
	]
);
