<?php
/**
 * Setup Front Page Post Type
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$cap            = nisje_get_setting( 'capability_key', 'front-page-layouts' );
$post_type_name = nisje_get_setting( 'post_type_name', 'front-page-layouts' );

$post_type_args = apply_filters(
	'nisje_post_type_front_page_args', [
		'labels'              => [
			'name'          => esc_html__( 'Front Pages', 'nisje-fpl' ),
			'singular_name' => esc_html__( 'Front Page', 'nisje-fpl' ),
		],
		'public'              => false,
		'publicly_queryable'  => false,
		'exclude_from_search' => false,
		'show_in_admin_bar'   => false,
		'show_in_nav_menus'   => true,
		'can_export'          => false,
		'show_ui'             => true,
		'query_var'           => false,
		'has_archive'         => false,
		'rewrite'             => false,
		'capability_type'     => $cap,
		'capabilities'        => [
			'create_posts'     => "create_{$cap}s",
			'delete_posts'     => "delete_{$cap}s",
			'upload_files_cpt' => "upload_files_{$cap}",
		],
		'map_meta_cap'        => true,
		'hierarchical'        => false,
		'menu_position'       => null,
		'menu_icon'           => 'dashicons-layout',
		'supports'            => [
			'title',
			'revisions',
			'author',
			'custom_fields',
		],
		'show_in_rest'        => false,
	]
);

/**
 * Filters the post type arguments for User Content.
 *
 * @param array $post_type_args Post type arguments.
 */
$post_type_args = apply_filters( 'nisje_post_type_front_page_args', $post_type_args );

register_post_type( $post_type_name, $post_type_args );
