<?php
/**
 * Custom links layout.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! function_exists( 'nisje_fpl_register_layout' ) ) {
	return;
}

nisje_fpl_register_layout(
	'links', [
		'key'        => '5b684df22f73e',
		'label'      => esc_html__( 'Links Card', 'nisje-fpl' ),
		'sub_fields' => [
			[
				'key'          => 'field_5b684e712f740',
				'label'        => esc_html__( 'Title', 'nisje-fpl' ),
				'name'         => 'title',
				'type'         => 'text',
				'instructions' => esc_html__( 'Add a title to appear above the links list.', 'nisje-fpl' ),
			],
			[
				'key'          => 'field_5b684e7e2f741',
				'label'        => esc_html__( 'Links', 'nisje-fpl' ),
				'name'         => 'links',
				'type'         => 'repeater',
				'instructions' => esc_html__( 'Add custom links to this card.', 'nisje-fpl' ),
				'collapsed'    => '',
				'layout'       => '',
				'button_label' => esc_html__( 'Add Link', 'nisje-fpl' ),
				'sub_fields'   => [
					[
						'key'          => 'field_5b684ea52f742',
						'label'        => esc_html__( 'Link Title', 'nisje-fpl' ),
						'name'         => 'link_title',
						'type'         => 'text',
						'instructions' => '',
						'required'     => 1,
					],
					[
						'key'          => 'field_5b684eaf2f743',
						'label'        => esc_html__( 'Link URL', 'nisje-fpl' ),
						'name'         => 'link_url',
						'type'         => 'url',
						'instructions' => '',
						'required'     => 1,
					],
				],
			],
			[
				'key'           => 'field_5b685637f9f4e',
				'label'         => esc_html__( 'Position', 'nisje-fpl' ),
				'name'          => 'position',
				'type'          => 'number',
				'instructions'  => esc_html__( 'Add the position in the feed you\'d like this card to be injected after.', 'nisje-fpl' ),
				'required'      => 1,
				'default_value' => 0,
			],
		],
	]
);
