<?php
/**
 * Custom Card layout.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! function_exists( 'nisje_fpl_register_layout' ) ) {
	return;
}

nisje_fpl_register_layout(
	'custom', [
		'key'        => '5b684ee82f74a',
		'label'      => esc_html__( 'Custom Card', 'nisje-fpl' ),
		'sub_fields' => [
			[
				'key'               => 'field_5b684f142f74d',
				'label'             => esc_html__( 'Columns', 'nisje-fpl' ),
				'name'              => 'columns',
				'type'              => 'radio',
				'instructions'      => esc_html__( 'Choose the number of columns this card will span across.', 'nisje-fpl' ),
				'required'          => 1,
				'choices'           => [
					1 => '1',
					3 => '3',
				],
				'allow_null'        => 0,
				'other_choice'      => 0,
				'save_other_choice' => 0,
				'default_value'     => 1,
				'layout'            => 'horizontal',
				'return_format'     => 'value',
			],
			[
				'key'           => 'field_5b68565ff9f50',
				'label'         => esc_html__( 'Position', 'nisje-fpl' ),
				'name'          => 'position',
				'type'          => 'number',
				'instructions'  => esc_html__( 'Add the position in the feed you\'d like this card to be injected after.', 'nisje-fpl' ),
				'required'      => 1,
				'default_value' => 0,
			],
			[
				'key'           => 'field_5b7568d8381d4',
				'label'         => esc_html__( 'Is Event?', 'nisje-fpl' ),
				'name'          => 'is_event',
				'type'          => 'true_false',
				'instructions'  => esc_html__( 'Give this custom card event styling.', 'nisje-fpl' ),
				'required'      => 0,
				'message'       => '',
				'default_value' => 0,
				'ui'            => 0,
				'ui_on_text'    => '',
				'ui_off_text'   => '',
			],
			[
				'key'           => 'field_5b684f5d2f74e',
				'label'         => esc_html__( 'Image', 'nisje-fpl' ),
				'name'          => 'image',
				'type'          => 'image',
				'instructions'  => '',
				'return_format' => 'array',
				'preview_size'  => 'thumbnail',
				'library'       => 'all',
				'mime_types'    => '',
			],
			[
				'key'           => 'field_5b684f892f753',
				'label'         => esc_html__( 'Author', 'nisje-fpl' ),
				'name'          => 'author',
				'type'          => 'user',
				'instructions'  => '',
				'role'          => '',
				'allow_null'    => 0,
				'multiple'      => 0,
				'return_format' => 'array',
			],
			[
				'key'   => 'field_5b684f682f74f',
				'label' => esc_html__( 'Title', 'nisje-fpl' ),
				'name'  => 'title',
				'type'  => 'text',
			],
			[
				'key'            => 'field_5b684f712f751',
				'label'          => esc_html__( 'Date', 'nisje-fpl' ),
				'name'           => 'date',
				'type'           => 'date_time_picker',
				'display_format' => 'd/m/Y g:i a',
				'return_format'  => 'Y-m-d H:i:s',
				'first_day'      => 1,
			],
			[
				'key'   => 'field_5b684f6c2f750',
				'label' => esc_html__( 'Excerpt', 'nisje-fpl' ),
				'name'  => 'excerpt',
				'type'  => 'wysiwyg',
			],
			[
				'key'   => 'field_5b684fa72f755',
				'label' => esc_html__( 'Card URL', 'nisje-fpl' ),
				'name'  => 'card_url',
				'type'  => 'url',
			],
		],
	]
);
