<?php
/**
 * Single Post layout.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! function_exists( 'nisje_fpl_register_layout' ) ) {
	return;
}

$post_types = apply_filters(
	'nisje_fpl_single_post_types', [
		0 => 'dekode-event',
		1 => 'nisje-event-group',
		2 => 'dekode-news',
		3 => 'nisje-news-group',
		4 => 'dekode-wiki',
		5 => 'nisje-wiki-group',
	]
);

$taxonomies = apply_filters( 'nisje_fpl_single_taxonomies', [] );

nisje_fpl_register_layout(
	'single', [
		'key'        => '5b6818de33e5c',
		'label'      => esc_html__( 'Single Card', 'nisje-fpl' ),
		'sub_fields' => [
			[
				'key'           => 'field_5b6818de33e5d',
				'label'         => esc_html__( 'Post', 'nisje-fpl' ),
				'name'          => 'post',
				'type'          => 'relationship',
				'instructions'  => esc_html__( 'Pick a post for this card to show.', 'nisje-fpl' ),
				'required'      => 1,
				'post_type'     => $post_types,
				'taxonomy'      => $taxonomies,
				'filters'       => [
					0 => 'search',
					1 => 'post_type',
					2 => 'taxonomy',
				],
				'elements'      => [
					0 => 'featured_image',
				],
				'min'           => 1,
				'max'           => 1,
				'return_format' => 'object',
			],
			[
				'key'           => 'field_5b685629f9f4d',
				'label'         => esc_html__( 'Position', 'nisje-fpl' ),
				'name'          => 'position',
				'type'          => 'number',
				'instructions'  => esc_html__( 'Add the position in the feed you\'d like this card to be injected after.', 'nisje-fpl' ),
				'required'      => 1,
				'default_value' => 0,
			],
		],
	]
);
