<?php
/**
 * Plugin Name: Nisje - Grieg
 * Description: Specific Grieg functionality
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     5.0.3
 * Text Domain: nisje-grieg
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_GRIEG_VERSION', '5.0.3' );
define( 'NISJE_GRIEG_PATH', \plugin_dir_path( __FILE__ ) );

/**
 * Include plugin components
 */
function nisje_grieg_include() {
	require __DIR__ . '/filters.php';

	// Components.
	require __DIR__ . '/components/grieg-retriever/grieg-retriever.php';
	require __DIR__ . '/components/gravity-forms/gf.php';
	require __DIR__ . '/components/grieg-dashboard/grieg-dashboard.php';
	require __DIR__ . '/components/grieg-signup-notifications/grieg-signup-notifications.php';

	require __DIR__ . '/inc/weak-password-error-message/weak-password-error-message.php';
	require __DIR__ . '/inc/coherent-style-in-registration-error-messages/coherent-style-in-registration-error-messages.php';
	require __DIR__ . '/inc/bp-custom-messages.php';

	if ( defined( 'WP_CLI' ) ) {
		require __DIR__ . '/wp-cli/wp-cli.php';
	}
}
add_action( 'nisje_include', 'nisje_grieg_include' );
