/**
 * Error messages in registration form on submit like required fields being empty are HTML5 style.
 * Error messages that appear after being processed by the backend are different. This file makes all
 * error messages not HTML5.
 */
(function ($) {
	$(document).ready(function () {

		const $registerPage = $('#register-page');

		if (!$registerPage.length) {
			return;
		}

		const $form = $('form#signup-form');

		const showValidationErrors = function () {
			$('.bp-messages.bp-feedback.error').remove();

			// Find all invalid fields within the form.
			$form.find('input:invalid, .field_choose-company select:invalid').each(function (index, node) {
				// Find the field's corresponding label
				const message = node.validationMessage || 'Invalid value.';
				$(node).before('<div class="bp-messages bp-feedback error"><p>' + message + '</p></div>');
			});

			if ($form.find('.datebox-selects select:invalid').length) {
				$('.datebox-selects').before('<div class="bp-messages bp-feedback error"><p>Please select a date</p></div>');
			}

			console.log($form.find(':invalid'))
			$form.find('input:invalid, select:invalid').first().focus();


		};


		$form.find( "input, select" ).on( "invalid",
			function( event ) {
				const hideHTML5ValidationMessages = function(event) {
					event.preventDefault();
				}

				hideHTML5ValidationMessages(event);


			});

		$('input[type=submit], button:not([type=button])', $form)
			.on('click', function(event) {
				showValidationErrors()
			});

	});
})(jQuery);
