<?php
/**
 * Grieg CLI
 *
 * @package Nisje
 */

declare( strict_types=1 );

namespace Dekode\Nisje\Commands;

use WP_CLI;
use Exception;
use StdClass;
use WP_Post;

if ( class_exists( 'WP_CLI' ) ) {
	/**
	 * Grieg convert functionality
	 */
	class Grieg_Convert {
		/**
		 * This function is run on the command "wp grieg-convert convert-news-thumbnail"
		 */
		public function convert_news_thumbnail() {
			$news_query = [
				'post_type'      => 'dekode-news',
				'posts_per_page' => -1,
				'post_status'    => 'any',
			];

			$query = new \WP_Query( $news_query );
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();

					$image = get_field( 'image' );
					if ( isset( $image['ID'] ) ) {
						update_post_meta( get_the_ID(), '_thumbnail_id', $image['ID'] );
					} else {
						echo 'Nothing';
					}
				}
			}
		}

		/**
		 * This function is run on the command "wp grieg-convert convert-news-group"
		 */
		public function convert_news_group() {
			$news_query = [
				'post_type'      => 'dekode-news',
				'posts_per_page' => -1,
				'post_status'    => 'any',
			];

			$query = new \WP_Query( $news_query );
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();

					$args = (array) get_post();

					$limits = get_post_meta( get_the_ID(), 'limits', true );
					if ( $limits && '1925' === $limits ) {
						$post_type   = nisje_get_setting( 'post_type_name_group', 'news' );
						$post_parent = 19;

						$args['post_type']   = $post_type;
						$args['post_parent'] = $post_parent;

						$post_id = wp_insert_post( $args );

						update_post_meta( $post_id, '_nisje_group_connection', $post_parent );

						WP_CLI::line( "\t" . 'ID: ' . get_the_ID() );
					}
				}
			}
		}

		/**
		 * This function is run on the command "wp grieg-convert map_user_to_member_type"
		 */
		public function map_user_to_member_type() {
			$mapping = [
				'19' => 'grieg-star',
				'31' => 'grieg-kapital',
				'26' => 'grieg-group-resources',
				'18' => 'grieg-seafood',
				'14' => 'grieg-shipbrokers',
				'28' => 'grieg-investor',
				'22' => 'ocean-quality',
				'25' => 'grieg-green',
				'16' => 'grieg-logistics',
			];

			$counter = 0;
			$stats   = [];
			foreach ( $mapping as $group_id => $member_type_key ) {
				$member_type_counter = 0;

				$group_members = groups_get_group_members( [
					'group_id'            => $group_id,
					'per_page'            => 999,
					'max'                 => 999,
					'exclude_admins_mods' => false,
				] );

				if ( $group_members && $group_members['members'] ) {
					foreach ( $group_members['members'] as $member ) {
						bp_set_member_type( $member->ID, $member_type_key );
						$counter++;
						$member_type_counter++;
					}
				}

				$stats[ $member_type_key ] = $member_type_counter;
			}

			WP_CLI::line( $counter . ' users mapped to a member type.' );
			foreach ( $stats as $member_key => $stat_counter ) {
				WP_CLI::line( $member_key . ': ' . $stat_counter );
			}
		}

		/**
		 * This function is run on the command "wp grieg-convert map_users_to_light_version"
		 */
		public function map_users_to_light_version() {
			$wp_users       = get_users( [ 'number' => 9999 ] );
			$normal_counter = 0;
			$light_counter  = 0;

			foreach ( $wp_users as $user ) {
				$is_light_user = absint( get_user_meta( $user->ID, 'dekode_lite_version', true ) );

				if ( $is_light_user ) {
					$light_counter++;
					xprofile_set_field_data( 'Light version', $user->ID, 'Yes' );
				} else {
					$normal_counter++;
					xprofile_set_field_data( 'Light version', $user->ID, 'No' );
				}
			}

			WP_CLI::line( $light_counter . ' light users.' );
			WP_CLI::line( $normal_counter . ' normal users.' );
		}
	}

	$grieg = new Grieg_Convert();

	WP_CLI::add_command( 'grieg-convert', $grieg );
}
