<?php
/**
 * Plugin Name: Nisje - Grieg
 * Description: Specific Grieg functionality
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     8.0.5
 * Text Domain: nisje-grieg
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_GRIEG_VERSION', '8.0.5' );
define( 'NISJE_GRIEG_PATH', \plugin_dir_path( __FILE__ ) );

/**
 * Include plugin components
 */
function nisje_grieg_include() {
	require __DIR__ . '/filters.php';

	// Components.
	require __DIR__ . '/components/grieg-retriever/grieg-retriever.php';
	require __DIR__ . '/components/gravity-forms/gf.php';
	require __DIR__ . '/components/grieg-dashboard/grieg-dashboard.php';
	require __DIR__ . '/components/grieg-signup-notifications/grieg-signup-notifications.php';

	require __DIR__ . '/inc/weak-password-error-message/weak-password-error-message.php';
	require __DIR__ . '/inc/coherent-style-in-registration-error-messages/coherent-style-in-registration-error-messages.php';
	require __DIR__ . '/inc/bp-custom-messages.php';

	if ( defined( 'WP_CLI' ) ) {
		require __DIR__ . '/wp-cli/wp-cli.php';
	}
}
add_action( 'nisje_include', 'nisje_grieg_include' );

/**
 * Frontend options
 */
add_filter( 'nisje_frontend_options', function( $options ) {
	$options['newsDefaultBackgroundColor'] = '#fff';
	$options['newsDefaultIsDark']          = false;
	$options['wikiTitle']                  = __( 'Inforoom', 'nisje-grieg' );
	$options['feedLayouts']['frontpage']   = '36868';
	return $options;
}, 20 );

/**
 * Change retriever title
 */
add_filter( 'nisje_retriever_title', function() {
	return __( 'Grieg in Media', 'nisje-grieg' );
} );

/**
 * Allowed Blocks
 *
 * @param bool|array $allowed_block_types Allowed block Types.
 *
 * @return bool|array $allowed_block_types Allowed block Types
 */
function nisje_grieg_allowed_block_types( $allowed_block_types ) {
	$allowed_block_types[] = 'nisje/iframe';
	$allowed_block_types[] = 'nisje/card-retriever';

	return $allowed_block_types;
}
add_filter( 'allowed_block_types', 'nisje_grieg_allowed_block_types', 20 );

/**
 * Editor mods
 */
function nisje_grieg_editor_assets() {
	wp_enqueue_script( 'nisje-plugin-retriever-admin' );
	wp_enqueue_style( 'nisje-plugin-retriever-admin' );
}
add_action( 'enqueue_block_editor_assets', 'nisje_grieg_editor_assets', 20 );

/**
 * Assets
 */
function nisje_grieg_assets() {
	wp_enqueue_script( 'nisje-plugin-retriever' );
	wp_enqueue_style( 'nisje-plugin-retriever' );
}
add_action( 'wp_enqueue_scripts', 'nisje_grieg_assets', 20 );

/**
 * Add featured image to old posts.
 *
 * @param string $content Post content.
 */
function filter_the_content_in_the_main_loop( string $content ): string {
	$pt = get_post_type();

	if ( 'dekode-news' === $pt || 'nisje-news-group' === $pt ) {
		$pd = get_post_time();

		if ( 1520907700 >= $pd || 1614680000 <= $pd || ! has_post_thumbnail() ) {
			return $content;
		}

		return '<div>' . get_the_post_thumbnail() . '</div>' . $content;
	}

	return $content;
}
add_filter( 'the_content', 'filter_the_content_in_the_main_loop', 1 );
