<?php
/**
 * Setup Post Type
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

$post_type_name = nisje_get_setting( 'post_type_name', 'grieg_retriever' );
$rest_endpoint  = nisje_get_setting( 'post_type_rest_endpoint', 'grieg_retriever' );

$post_type_args = apply_filters(
	'nisje_post_type_nisje_retriever_args', [
		'labels'                => [
			'name'          => esc_html__( 'Retriever', 'nisje-grieg' ),
			'singular_name' => esc_html__( 'Retriever', 'nisje-grieg' ),
		],
		'exclude_from_search'   => false,
		'show_in_admin_bar'     => false,
		'show_in_nav_menus'     => false,
		'can_export'            => true,
		'show_ui'               => true,
		'query_var'             => false,
		'has_archive'           => false,
		'capability_type'       => 'post',
		'rewrite'               => false,
		'hierarchical'          => false,
		'menu_position'         => null,
		'menu_icon'             => 'dashicons-layout',
		'supports'              => [
			'editor',
			'excerpt',
			'title',
		],
		'show_in_rest'          => true,
		'rest_base'             => $rest_endpoint,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
	]
);

register_post_type( $post_type_name, $post_type_args ); // phpcs:ignore
