<?php
/**
 * Setup Custom Dashboard
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Dekode\Nisje\Components;

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! class_exists( '\\Dekode\\Nisje\\Components\\Grieg_Dashboard' ) && class_exists( '\\Dekode\\Nisje\\Components\\Component' ) ) {
	/**
	 * Dashboard component class
	 */
	class Grieg_Dashboard extends Component {
		/**
		 * Constructor
		 */
		public function __construct() {
			$path = trailingslashit( __DIR__ );

			parent::start(
				'nb-dashboard',
				esc_html__( 'NB Dashboard', 'nisje-grieg' ),
				$path
			);
		}

		/**
		 * Includes
		 */
		public function includes() {
			$this->include_file( 'helpers.php' );
			$this->include_file( 'csv-export.php' );
		}

		/**
		 * Setup filters
		 */
		public function setup_filters() {
			if ( is_admin() ) {
				if ( ! class_exists( 'WP_List_Table' ) ) {
					require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
				}

				/**
				 * Custom User dashboard.
				 */
				$this->include_file( 'lists/class-grieg-list-table.php' );
				$this->include_file( 'dashboards/class-grieg-users-dashboard.php' );
				$grieg_dashboard = new \Nisje\Grieg\Dashboard\Grieg_Users_Dashboard();
				$grieg_dashboard->init();
			}
		}
	}
}
