/**
 * If accept-weak-password-checkbox is not checked, the submit button is disabled, but no
 * error message is displayed. This is confusing for the user.
 * This file adds required to the checkbox whenever it applies, so an error message
 * is shown on submit.
 */
(function ($) {
	$(document).ready(function () {

		const $registerPage = $('#register-page');

		if (!$registerPage.length) {
			return;
		}

		var $submitButton = $('#submit')
		var $weakRow = $('.pw-weak')
		var $weakCheckbox = $weakRow.find('.pw-checkbox')
		var $passwordText = $('#pass1-text')

		$passwordText.attr('minlength', 8)

		$passwordText.keyup(function () {
			$submitButton.prop('disabled', false)
		})

		$weakCheckbox.change(function () {
			$submitButton.prop('disabled', false)
		})

		// If weak password checkbox becomes visible, we need to make it required and the other way round.
		var observer = new MutationObserver(function (mutations) {
			mutations.forEach(function (mutationRecord) {
				let node = mutationRecord.target
				$weakCheckbox.prop('required', node.style.display === 'block')

			})
		})

		observer.observe($weakRow.get(0), { attributes: true, attributeFilter: ['style'] })

	})
})(jQuery)
