<?php
/**
 * Gravity forms for Grieg
 *
 * @package Nijse
 */

namespace Nisje\Grieg\GravityForms;

/**
 * Add PDF specific query vars.
 *
 * @param array $vars Registered query vars.
 * @return array $vars Added PDF specific query vars
 */
function query_vars( array $vars ) : array {
	$vars[] = 'grieg_gf';

	return $vars;
}
add_filter( 'query_vars', __NAMESPACE__ . '\\query_vars' );

/**
 * Template include
 *
 * @param  string $template Template.
 * @return string $template Template.
 */
function template( string $template ) {
	if ( is_user_logged_in() && get_query_var( 'grieg_gf' ) ) {
		$template = NISJE_GRIEG_PATH . 'components/gravity-forms/template.php';
	}

	return $template;
}
add_action( 'template_include', __NAMESPACE__ . '\\template' );
