<?php
/**
 * Setup Grieg Retriever Settings.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$field_key_prefix = nisje_get_setting( 'field_key_prefix', $this->settings_key );

acf_add_local_field_group(
	[
		'key'                   => $field_key_prefix . '_grieg_retriever',
		'title'                 => esc_html__( 'Grieg Retriever', 'nisje-grieg' ),
		'fields'                => [
			[
				'key'           => $field_key_prefix . '_author_id',
				'label'         => esc_html__( 'Author id', 'nisje-grieg' ),
				'name'          => $field_key_prefix . '_author_id',
				'type'          => 'user',
				'instructions'  => esc_html__( 'Author ID for the import. Default value is user id 1. All articles will be imported as this user.', 'nisje-grieg' ),
				'required'      => 0,
				'role'          => '',
				'allow_null'    => 1,
				'multiple'      => 0,
				'return_format' => 'id',
			],
			[
				'key'           => $field_key_prefix . '_override_author_name',
				'label'         => esc_html__( 'Override author name', 'nisje-grieg' ),
				'name'          => $field_key_prefix . '_override_author_name',
				'type'          => 'text',
				'instructions'  => esc_html__( 'Override author name presented in the feed.', 'nisje-grieg' ),
				'required'      => 0,
				'allow_null'    => 1,
				'return_format' => 'string',
			],
		],
		'location'              => [
			[
				[
					'param'    => 'options_page',
					'operator' => '==',
					'value'    => nisje_get_setting( 'settings_menu_key', $this->settings_key ),
				],
			],
		],
		'menu_order'            => 0,
		'position'              => 'normal',
		'style'                 => 'default',
		'label_placement'       => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen'        => '',
		'active'                => 1,
		'description'           => '',
	]
);
