<?php
/**
 * Setup Learndash Settings.
 *
 * @package Nisje
 */

declare( strict_types = 1 );

defined( 'ABSPATH' ) || die( 'Shame on you' );

$field_key_prefix = nisje_get_setting( 'field_key_prefix', $this->settings_key );

if ( function_exists( 'acf_add_local_field_group' ) ) :

	acf_add_local_field_group([
		'key'                   => 'group_5c8a48d2edf0d',
		'title'                 => 'Learndash',
		'fields'                => [
			[
				'key'               => $field_key_prefix . '_field_5c8a492610b5a',
				'label'             => 'External courses endpoint',
				'name'              => $field_key_prefix . '_external_courses_endpoint',
				'type'              => 'text',
				'instructions'      => 'Enter the external courses endpoint. Example: http://your-learndash-site.com/wp-json/ldlms/v1/sfwd-courses',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => [
					'width' => '',
					'class' => '',
					'id'    => '',
				],
				'default_value'     => '',
				'placeholder'       => '',
				'prepend'           => '',
				'append'            => '',
				'maxlength'         => '',
			],
		],
		'location'              => [
			[
				[
					'param'    => 'options_page',
					'operator' => '==',
					'value'    => 'nisje-settings-learndash',
				],
			],
		],
		'menu_order'            => 0,
		'position'              => 'normal',
		'style'                 => 'default',
		'label_placement'       => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen'        => '',
		'active'                => 1,
		'description'           => '',
	]);

endif;
