<?php
/**
 * Learndash Front Page ayout.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! function_exists( 'nisje_fpl_register_layout' ) ) {
	return;
}

$categories = [
	0 => esc_html__( 'All', 'nisje-learndash' ),
];

if ( is_admin() ) {
	$endpoint = nisje_get_setting( 'external_courses_endpoint', $this->settings_key ) . '?_embed';

	$body = get_transient( 'nisje_learndash_category' );
	if ( false === $body ) {
		$response = wp_remote_get( $endpoint );
		$body     = wp_remote_retrieve_body( $response );

		set_transient( 'nisje_learndash_category', $body, 3 * MINUTE_IN_SECONDS );
	}

	if ( $body && ! is_wp_error( $body ) ) {
		$courses = json_decode( $body, true );
		foreach ( $courses as $course ) {
			if ( isset( $course['_embedded'], $course['_embedded']['wp:term'] ) && is_array( $course['_embedded']['wp:term'] ) ) {
				foreach ( $course['_embedded']['wp:term'] as $terms ) {
					if ( is_array( $terms ) && ! empty( $terms ) ) {
						foreach ( $terms as $term_arr ) {
							if ( isset( $term_arr['taxonomy'], $term_arr['id'], $term_arr['name'] ) && 'ld_course_category' === $term_arr['taxonomy'] ) {
								$categories[ $term_arr['id'] ] = $term_arr['name'];
							}
						}
					}
				}
			}
		}
	}
}

nisje_fpl_register_layout(
	'learndash', [
		'key'        => '5b684ee82f74b',
		'label'      => esc_html__( 'Learndash Card', 'nisje-learndash' ),
		'sub_fields' => [
			[
				'key'     => 'field_5b68565ff9f41',
				'type'    => 'message',
				'message' => esc_html__( 'This card will show all Learndash courses if an endpoint is set.', 'nisje-learndash' ),
			],
			[
				'key'               => 'field_5b68565ffdewd9f59',
				'label'             => esc_html__( 'Restrict to a specific category', 'nisje-learndash' ),
				'name'              => 'category',
				'type'              => 'select',
				'instructions'      => esc_html__( 'Add the category ID of the category you want to filter by.', 'nisje-learndash' ),
				'required'          => 0,
				'conditional_logic' => [],
				'wrapper'           => [
					'width' => '33',
					'class' => '',
					'id'    => '',
				],
				'choices'           => $categories,
				'default_value'     => [
					'0',
				],
				'allow_null'        => 0,
				'multiple'          => 0,
				'ui'                => 0,
				'ajax'              => 0,
				'return_format'     => 'value',
				'placeholder'       => '',
			],
			[
				'key'           => 'field_5b68565ff9f59',
				'label'         => esc_html__( 'Position', 'nisje-learndash' ),
				'name'          => 'position',
				'type'          => 'number',
				'instructions'  => esc_html__( 'Add the position in the feed you\'d like this card to be injected after.', 'nisje-learndash' ),
				'required'      => 1,
				'default_value' => 0,
			],
		],
	]
);
