<?php
/**
 * Setup Learndash Component
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Components;

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Learndash Component Class
 */
class Learndash extends Component {

	/**
	 * Constructor
	 */
	public function __construct() {
		$path = trailingslashit( dirname( __FILE__ ) );

		parent::start(
			'learndash',
			esc_html__( 'Learndash', 'nisje-learndash' ),
			$path
		);
	}

	/**
	 * Setup globals
	 */
	public function setup_globals() {
		$settings = get_option( $this->option_key );

		if ( is_array( $settings ) && ! empty( $settings ) ) {
			foreach ( $settings as $key => $value ) {
				$this->settings[ $key ] = $value;
			}
		}

		$defaults = [
			'name'              => $this->name,
			'option_key'        => $this->option_key,
			'field_key_prefix'  => 'nisje_learndash',
			'settings_menu_key' => 'nisje-settings-learndash',
		];

		$this->settings = wp_parse_args( $this->settings, $defaults );

		$this->public_settings = [
			'external_courses_endpoint' => isset( $this->settings['external_courses_endpoint'] ) ? $this->settings['external_courses_endpoint'] : '',
		];
	}

	/**
	 * Add frontend options
	 *
	 * @param array $options Options.
	 */
	public function add_frontend_option( $options ) {
		$field_key_prefix = nisje_get_setting( 'field_key_prefix', $this->settings_key );

		$options['features']['learndash'] = true;
		$options['learndashEndpoint']     = get_field( $field_key_prefix . '_external_courses_endpoint', 'option' ) ?? false;

		return $options;
	}

	/**
	 * Setup Filters
	 */
	public function setup_filters() {
		if ( is_admin() ) {
			add_action( 'nisje_settings_register_field_groups', [ $this, 'register_field_group' ] );
			add_action( 'nisje_settings_add_option_page', [ $this, 'setup_settings_menu' ] );
			add_action( 'nisje_settings_populate_options_from_acf', [ $this, 'populate_acf_settings' ] );
		}

		add_action( 'nisje_fpl_register_layouts', [ $this, 'register_learndash_card' ] );
		add_filter( 'nisje_frontend_options', [ $this, 'add_frontend_option' ] );
	}

	/**
	 * Setup the admin page.
	 */
	public function setup_settings_menu() {
		acf_add_options_sub_page( [
			'page_title'  => $this->label,
			'menu_title'  => $this->label,
			'capability'  => nisje_get_setting( 'settings_cap', 'core' ),
			'menu_slug'   => nisje_get_setting( 'settings_menu_key', $this->settings_key ),
			'parent_slug' => nisje_get_setting( 'settings_key', 'core' ),
		] );
	}

	/**
	 * Include acf field groups.
	 */
	public function register_field_group() {
		$this->include_file( 'acf/field-groups/acf-field-group-options-learndash.php' );
	}

	/**
	 * Populate ACF Options
	 *
	 * @param WP_Screen $screen Screen object.
	 */
	public function populate_acf_settings( $screen ) {
		if ( false !== strpos( $screen->id, nisje_get_setting( 'settings_menu_key', $this->settings_key ) ) ) {
			$learndash        = [
				'external_courses_endpoint' => '',
			];
			$field_key_prefix = nisje_get_setting( 'field_key_prefix', $this->settings_key );

			$learndash['external_courses_endpoint'] = get_field( $field_key_prefix . '_external_courses_endpoint', 'option' );

			update_option( $this->option_key, $learndash );
		}
	}

	/**
	 * Register Learndash FPL card.
	 */
	public function register_learndash_card() {
		$this->include_file( 'layouts/learndash.php' );
	}
}
